<?php
/**
 * Class that operate on table 'accountmovementkind'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2021-08-23 23:51
 */
class AccountmovementkindMySqlDAO implements AccountmovementkindDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return AccountmovementkindMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM accountmovementkind WHERE accountmovementkindid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM accountmovementkind';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM accountmovementkind ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param accountmovementkind primary key
 	 */
	public function delete($accountmovementkindid){
		$sql = 'DELETE FROM accountmovementkind WHERE accountmovementkindid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($accountmovementkindid);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param AccountmovementkindMySql accountmovementkind
 	 */
	public function insert($accountmovementkind){
		$sql = 'INSERT INTO accountmovementkind (accountmovementkindname, accountmovementkinddate, userid, tablename, conditions, accountmovementkindcomment) VALUES (?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($accountmovementkind->accountmovementkindname);
		$sqlQuery->set($accountmovementkind->accountmovementkinddate);
		$sqlQuery->setNumber($accountmovementkind->userid);
		$sqlQuery->set($accountmovementkind->tablename);
		$sqlQuery->setNumber($accountmovementkind->conditions);
		$sqlQuery->setString2($accountmovementkind->accountmovementkindcomment);

		$id = $this->executeInsert($sqlQuery);	
		$accountmovementkind->accountmovementkindid = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param AccountmovementkindMySql accountmovementkind
 	 */
	public function update($accountmovementkind){
		$sql = 'UPDATE accountmovementkind SET accountmovementkindname = ?, accountmovementkinddate = ?, userid = ?, tablename = ?, conditions = ?, accountmovementkindcomment = ? WHERE accountmovementkindid = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($accountmovementkind->accountmovementkindname);
		$sqlQuery->set($accountmovementkind->accountmovementkinddate);
		$sqlQuery->setNumber($accountmovementkind->userid);
		$sqlQuery->set($accountmovementkind->tablename);
		$sqlQuery->setNumber($accountmovementkind->conditions);
		$sqlQuery->setString2($accountmovementkind->accountmovementkindcomment);

		$sqlQuery->setNumber($accountmovementkind->accountmovementkindid);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM accountmovementkind';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByAccountmovementkindname($value){
		$sql = 'SELECT * FROM accountmovementkind WHERE accountmovementkindname = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByAccountmovementkinddate($value){
		$sql = 'SELECT * FROM accountmovementkind WHERE accountmovementkinddate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByUserid($value){
		$sql = 'SELECT * FROM accountmovementkind WHERE userid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByTablename($value){
		$sql = 'SELECT * FROM accountmovementkind WHERE tablename = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByConditions($value){
		$sql = 'SELECT * FROM accountmovementkind WHERE conditions = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByAccountmovementkindcomment($value){
		$sql = 'SELECT * FROM accountmovementkind WHERE accountmovementkindcomment = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByAccountmovementkindname($value){
		$sql = 'DELETE FROM accountmovementkind WHERE accountmovementkindname = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByAccountmovementkinddate($value){
		$sql = 'DELETE FROM accountmovementkind WHERE accountmovementkinddate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByUserid($value){
		$sql = 'DELETE FROM accountmovementkind WHERE userid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByTablename($value){
		$sql = 'DELETE FROM accountmovementkind WHERE tablename = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByConditions($value){
		$sql = 'DELETE FROM accountmovementkind WHERE conditions = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByAccountmovementkindcomment($value){
		$sql = 'DELETE FROM accountmovementkind WHERE accountmovementkindcomment = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return AccountmovementkindMySql 
	 */
	protected function readRow($row){
		$accountmovementkind = new Accountmovementkind();
		
		$accountmovementkind->accountmovementkindid = $row['accountmovementkindid'];
		$accountmovementkind->accountmovementkindname = $row['accountmovementkindname'];
		$accountmovementkind->accountmovementkinddate = $row['accountmovementkinddate'];
		$accountmovementkind->userid = $row['userid'];
		$accountmovementkind->tablename = $row['tablename'];
		$accountmovementkind->conditions = $row['conditions'];
		$accountmovementkind->accountmovementkindcomment = $row['accountmovementkindcomment'];

		return $accountmovementkind;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return AccountmovementkindMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>